<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('phone', 'email', 'blood_type_id', 'name', 'password', 'd_o_b', 'last_donation_date', 'pin_code', 'api_token');

    public function bloodType()
    {
        return $this->belongsToMany('App\Models\BloodType');
    }

    public function posts()
    {
        return $this->belongsToMany('App\Models\Post');
    }

    public function donation_request()
    {
        return $this->belongsTo('App\Models\Donation_request');
    }

    public function governorate()
    {
        return $this->belongsToMany('App\Models\Governorate');
    }

    public function noitifcation()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

}